package eu.ascens.ui.util

import com.google.common.base.Joiner
import java.util.List

class UiHelper {
	
	public static def String getFormalParamsAsString(List<String> types, List<String> names, String separator){
		var StringBuilder sb = new StringBuilder();
		if(types.length != names.length){
			return "";
		}else{
			for(k : 0..<names.length){
				if(k != 0)	sb.append(separator)
				sb.append(types.get(k) + " " + names.get(k));
			}
		}
		return sb.toString;
	}
	
	public static def String getFormalParamNamesAsString(List<String> names, String separator){
		var Joiner joiner = Joiner.on(separator).skipNulls();
		return joiner.join(names);
	}
}