package eu.ascens.ui.contentassist

import eu.ascens.helenaText.IncomingMessageCall
import eu.ascens.helenaText.MsgDirection
import eu.ascens.helenaText.OutgoingMessageCall
import org.eclipse.xtext.Assignment
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor

import static eu.ascens.ui.util.UiHelper.*

import static extension eu.ascens.helenaText.util.ExtensionMethods_RoleBehavior.*
import static extension eu.ascens.helenaText.util.ExtensionMethods_RoleType.*
import static extension eu.ascens.helenaText.util.ExtensionMethods_Param.*
/**
 * see http://www.eclipse.org/Xtext/documentation.html#contentAssist on how to customize content assistant
 */
class HelenaTextProposalProvider extends AbstractHelenaTextProposalProvider {

	public def void completeIncomingMessageCall_MsgName(IncomingMessageCall incMsgCall, Assignment assignment, ContentAssistContext context,
		ICompletionProposalAcceptor acceptor) {

		// call implementation of superclass
		super.completeIncomingMessageCall_MsgName(incMsgCall, assignment, context, acceptor);

		var inRoleMsgs = incMsgCall.parentRoleBehavior.roleTypeRef.getAllMessagesOfDirection(MsgDirection.IN);
		for(msg : inRoleMsgs){
			var roleParams = msg.formalRoleParamsBlock.params;
			var dataParams = msg.formalDataParamsBlock.params;
			var rpNames = roleParams.map[p | p.name];
			var dpNames = dataParams.map[p | p.name];
			var rpTypes = roleParams.map[p | p.type.name];
			var dpTypes = dataParams.map[p | p.type.type.simpleName];
			
			
			var proposal = '''«msg.name»(«getFormalParamsAsString(rpTypes, rpNames, ",")»)(«getFormalParamsAsString(dpTypes, dpNames, ",")»)''';
			acceptor.accept(createCompletionProposal(proposal, context));
		}
	}
	
	
	

	public def void completeOutgoingMessageCall_MsgName(OutgoingMessageCall outMsgCall, Assignment assignment, ContentAssistContext context,
		ICompletionProposalAcceptor acceptor) {

		// call implementation of superclass
		super.completeOutgoingMessageCall_MsgName(outMsgCall, assignment, context, acceptor);

		var outRoleMsgs = outMsgCall.parentRoleBehavior.roleTypeRef.getAllMessagesOfDirection(MsgDirection.OUT);
		var outMsgsOfReceiver = outMsgCall.receiver.roleTypeForRef.getAllMessagesOfDirection(MsgDirection.IN).toList;
		for(msg : outRoleMsgs){
			if(outMsgsOfReceiver.exists[receiverMsg | receiverMsg.name == msg.name]){
				val rpNames = msg.formalRoleParamsBlock.params.map[p | p.name];
				val dpNames = msg.formalDataParamsBlock.params.map[p | p.name];
				var proposal = '''«msg.name»(«getFormalParamNamesAsString(rpNames, ",")»)(«getFormalParamNamesAsString(dpNames, ",")»)''';
				acceptor.accept(createCompletionProposal(proposal, context));
			}
		}

	}
}
