package eu.ascens.helena.metadata;

import eu.ascens.helena.dev.Role;
import eu.ascens.helena.dev.exceptions.ConfigurationFinishedException;
import eu.ascens.helena.dev.exceptions.TypeAlreadyExistsException;
import eu.ascens.helena.dev.exceptions.TypeDoesNotExistException;

/**
 * This class represents field types of role types in Helena
 * 
 * @author Annabelle Klarl
 */
public class RoleFieldType extends AbstractFieldType<Role> {

	/**
	 * This method creates a field type for a role type for the given name and
	 * type.
	 * 
	 * If there is none for the name and type, a new one is created. If
	 * there exists already one, an {@link TypeAlreadyExistsException} is
	 * thrown.
	 * 
	 * @param name the name of the field
	 * @param type the type of the field
	 * @return
	 * @throws ConfigurationFinishedException This exception is thrown if this
	 *             method was called after the configuration of the
	 *             ensemble-based system was finished.
	 * @throws TypeAlreadyExistsException This exception is thrown if a type
	 *             with the same name already exists.
	 */
	public static RoleFieldType createType(String name,
	        Class<? extends Role> type) throws ConfigurationFinishedException,
	                TypeAlreadyExistsException {

		RoleFieldType newRoleFieldType = new RoleFieldType(name, type);
		AbstractFieldType.checkAndAddType(newRoleFieldType);
		return newRoleFieldType;
	}

	/**
	 * This method retrieves an field type for a role type for the given name.
	 * 
	 * @return
	 * @throws TypeDoesNotExistException This exception is thrown if there
	 *             exists not type for the given class.
	 */
	public static RoleFieldType getType(String name)
	        throws TypeDoesNotExistException {
		return AbstractFieldType.getType(name, RoleFieldType.class);
	}

	// //////////// Role Field Type Declaration ///////////////////////

	private RoleFieldType(String name, Class<? extends Role> type) {
		super(name, type);
	}
}
