package eu.ascens.helena.dev.exceptions;

/**
 * This exception is thrown if a value should have been set for a variable whose
 * type differs from the value.
 * 
 * @author Annabelle Klarl
 *
 */
public class ValueNotMatchingVariableTypeException extends RuntimeException {

	private static final long serialVersionUID = -7871473539092745541L;
	private Class<?> desiredParamType;
	private Class<?> actualParamType;

	public ValueNotMatchingVariableTypeException(Class<?> desiredParamType,
	        Class<?> actualParamType) {
		this.desiredParamType = desiredParamType;
		this.actualParamType = actualParamType;
	}

	@Override
	public String toString() {
		return "Could not set value. Desired type: "
		        + this.desiredParamType.getSimpleName() + ", actual type: "
		        + this.actualParamType.getSimpleName();
	}
}
