package eu.ascens.helena.dev.exceptions;

/**
 * This exception is thrown if a new type (ensemble, role, component, message,
 * operation, ...) should have been created which already existed.
 * 
 * @author Annabelle Klarl
 *
 */
public class TypeAlreadyExistsException extends RuntimeException {

	private static final long serialVersionUID = -1682653281813916668L;
	private Class<?> type;

	public TypeAlreadyExistsException(Class<?> type) {
		this.type = type;
	}

	@Override
	public String toString() {
		return "Type " + this.type.getSimpleName()
		        + " could not be created, since it already exists.";
	}
}
