package eu.ascens.helena.dev.exceptions;

import eu.ascens.helena.dev.Ensemble;
import eu.ascens.helena.metadata.RoleType;

/**
 * This exception is thrown if an instance of a certain role type should have
 * been created in an ensemble, but the upper bound for instances of that type
 * was already reached.
 *
 * @author Annabelle Klarl
 */
public class TooManyRoleInstancesException extends Exception {

	private static final long serialVersionUID = -676984148803250242L;
	private RoleType roleType;
	private Ensemble ens;

	public TooManyRoleInstancesException(RoleType roleType, Ensemble ens) {
		this.roleType = roleType;
		this.ens = ens;
	}

	@Override
	public String toString() {
		return "Too many role instance of type " + this.roleType
				+ " in ensemble " + this.ens.getType();
	}
}
