package eu.ascens.helena.dev.exceptions;

import eu.ascens.helena.metadata.EnsembleStructure;
import eu.ascens.helena.metadata.RoleType;

/**
 * This exception is thrown if an instance of a role type should have been
 * created in an ensemble whose type does not allow the given role
 * type.
 * 
 * @author Annabelle Klarl
 *
 */
public class RoleTypeNotAllowedForEnsembleException extends Exception {

	private static final long serialVersionUID = 915892061086369271L;
	private RoleType roleType;
	private EnsembleStructure ensembleStructure;

	public RoleTypeNotAllowedForEnsembleException(RoleType roleType,
	        EnsembleStructure ensembleStructure) {
		this.roleType = roleType;
		this.ensembleStructure = ensembleStructure;
	}

	@Override
	public String toString() {
		return "Role type " + this.roleType
		        + " not allowed for ensemble structure "
		        + this.ensembleStructure;
	}

}
