package eu.ascens.helena.dev.exceptions;

/**
 * This exception is thrown if the given property (attribute, method, parameter)
 * is not declared in the given class.
 *
 * @author Annabelle Klarl
 */
public class PropertyNotDeclaredInClassException extends Exception {

	private static final long serialVersionUID = -6722450389587397358L;
	private String property;
	private Class<?> declaringClass;

	public PropertyNotDeclaredInClassException(String property,
			Class<?> declaringClass) {
		this.property = property;
		this.declaringClass = declaringClass;
	}

	@Override
	public String toString() {
		return "The property " + this.property
				+ " did not exist in the implementation class "
				+ this.declaringClass.getSimpleName();
	}

}
