package eu.ascens.helena.dev.exceptions;

/**
 * This exception is thrown if two messages were compared/traversed and their
 * parameter lists were not equal (e.g., one was shorter).
 * 
 * @author Annabelle Klarl
 *
 */
public class ParameterListNotEqualException extends RuntimeException {

	private static final long serialVersionUID = -3146770857545138201L;

	private ParamListType listType;
	private int desiredListSize;
	private int actualListSize;

	public ParameterListNotEqualException(ParamListType listType,
	        int desiredSize, int actualSize) {
		this.desiredListSize = desiredSize;
		this.actualListSize = actualSize;
	}

	public enum ParamListType {
		ROLE_PARAMS("roleparams"), DATA_PARAMS("dataparams");

		private String type;

		private ParamListType(String type) {
			this.type = type;
		}

		@Override
		public String toString() {
			return this.type;
		}
	}

	@Override
	public String toString() {
		return "Size of list of " + this.listType + " not equal. Desired size: "
		        + this.desiredListSize + ", actual size: " + this.actualListSize;
	}
}
