package eu.ascens.helena.dev.exceptions;

import eu.ascens.helena.dev.Message;

/**
 * This exception is thrown if a message is received which was not expected,
 * i.e., the message type did not fit to the expected type.
 *
 * @author Annabelle Klarl
 */
public class MessageNotExpectedException extends Exception {

	private static final long serialVersionUID = -7871473539092745541L;
	private Class<? extends Message> msgType;

	public MessageNotExpectedException(Class<? extends Message> msgType) {
		this.msgType = msgType;
	}

	@Override
	public String toString() {
		return this.msgType.getSimpleName() + " was not expected.";
	}
}
