package eu.ascens.helena.dev.exceptions;

import eu.ascens.helena.metadata.MessageType;
import eu.ascens.helena.metadata.RoleType;

/**
 * This exception is thrown if a message is exchanged which is not allowed as
 * output for the sending role type.
 *
 * @author Annabelle Klarl
 */
public class MessageNotAllowedAsOutputException extends Exception {

	private static final long serialVersionUID = -7871473539092745541L;
	private MessageType msgType;
	private RoleType roleType;

	public MessageNotAllowedAsOutputException(MessageType msgType,
	        RoleType roleType) {
		this.msgType = msgType;
		this.roleType = roleType;
	}

	@Override
	public String toString() {
		return this.msgType.getSimpleName() + " not allowed as output for "
		        + this.roleType.getSimpleName();
	}
}
