package eu.ascens.helena.dev.exceptions;

import eu.ascens.helena.metadata.MessageType;
import eu.ascens.helena.metadata.RoleType;

/**
 * This exception is thrown if a message is exchanged which is not allowed as
 * input for the receiving role type.
 *
 * @author Annabelle Klarl
 */
public class MessageNotAllowedAsInputException extends Exception {

	private static final long serialVersionUID = -7871473539092745541L;
	private MessageType msgType;
	private RoleType roleType;

	public MessageNotAllowedAsInputException(MessageType msgType,
	        RoleType roleType) {
		this.msgType = msgType;
		this.roleType = roleType;
	}

	@Override
	public String toString() {
		return this.msgType.getSimpleName() + " not allowed as input for "
		        + this.roleType.getSimpleName();
	}
}
