package eu.ascens.helena.dev.exceptions;

import eu.ascens.helena.dev.Action;
import eu.ascens.helena.dev.Role;

/**
 * This class represents the super class of all exceptions which can occur
 * during execution of a Helena ensemble. This exception is always caused during
 * executing an action.
 *
 * @author Annabelle Klarl
 */
public abstract class HelenaRuntimeException extends Exception {

	private static final long serialVersionUID = 1486948472265855728L;

	protected Action action;
	protected Role role;
	protected Exception cause;

	public HelenaRuntimeException(Action action, Role role, Exception cause) {
		this.action = action;
		this.role = role;
		this.cause = cause;
	}

	public Action getAction() {
		return this.action;
	}

	@Override
	public Exception getCause() {
		return this.cause;
	}

	@Override
	public String toString() {
		if (this.action != null) {
			return "The exception " + this.getClass().getSimpleName()
					+ " occurred during executing the action " + this.action
					+ " for " + this.role.getType() + ". Cause: " + this.cause;
		}
		else {
			return "The exception " + this.getClass().getSimpleName()
					+ " occurred during executing an unknown action. Cause: "
					+ this.cause;
		}
	}
}
