package eu.ascens.helena.dev.exceptions;

/**
 * This exception is thrown whenever the user tries to create a new type after
 * the configuration of the system has been finished.
 * 
 * @author Annabelle Klarl
 * 
 */
public class ConfigurationFinishedException extends RuntimeException {

	private static final long serialVersionUID = 500548965596052585L;
	private Class<?> type;

	public ConfigurationFinishedException(Class<?> type) {
		this.type = type;
	}

	@Override
	public String toString() {
		return "Tried to create type " + this.type.getSimpleName()
		        + " after finishing configuration.";
	}

}
