package eu.ascens.helena.dev.exceptions;

import eu.ascens.helena.dev.Component;
import eu.ascens.helena.dev.Ensemble;
import eu.ascens.helena.metadata.RoleType;

/**
 * This exception is thrown if a role should be created on a component which
 * already adopts it.
 * 
 * @author Annabelle Klarl
 *
 */
public class ComponentAlreadyAdoptsRoleException extends Exception {

	private static final long serialVersionUID = 4513860882052359098L;
	private Component owner;
	private RoleType roleType;
	private Ensemble ens;

	public ComponentAlreadyAdoptsRoleException(Component owner,
	        RoleType roleType, Ensemble ensemble) {
		this.owner = owner;
		this.roleType = roleType;
		this.ens = ensemble;
	}

	@Override
	public String toString() {
		return "An instance of role type " + this.roleType
		        + " should be created on a component of type "
		        + this.owner.getType() + " which already adopts it.";
	}

}
