package eu.ascens.helena.dev;

import eu.ascens.helena.dev.exceptions.ValueNotMatchingVariableTypeException;

/**
 * This class represents a variable in Helena.
 *
 * @author Annabelle Klarl
 * @param <T> the type of the value in the variable
 */
public class Variable<T> {

	private T value;
	private final Class<T> type;

	/**
	 * Constructor initializing the variable with the value null
	 *
	 * @param type
	 */
	public Variable(Class<T> type) {
		this(null, type);
	}

	/**
	 * Constructor
	 * 
	 * @param value
	 * @param type
	 */
	public Variable(T value, Class<T> type) {
		this.value = value;
		this.type = type;
	}

	public T getValue() {
		return this.value;
	}

	@SuppressWarnings("unchecked")
	public void setValue(Object value)
			throws ValueNotMatchingVariableTypeException {
		if ((value != null) && (value.getClass() != this.type)) {
			throw new ValueNotMatchingVariableTypeException(value.getClass(),
					this.type.getClass());
		}

		this.value = (T) value;
	}

	public Class<T> getType() {
		return this.type;
	}
}
