package eu.ascens.helena.dev;

/**
 * This class represents the quit process expression which advises to give up
 * the role and terminates the behavior.
 *
 * @author Annabelle Klarl
 */
public class Quit extends ProcessExpression {

	private static Quit singleton;

	private Quit() {
	}

	public static Quit getInstance() {
		if (singleton == null) {
			singleton = new Quit();
		}
		return singleton;
	}

	/**
	 * This method quits the role by advising the owning component to give up
	 * the role and closes its input channel.
	 *
	 * @param source the role executing the process expression
	 * @return an empty process expression (not null)
	 */
	@Override
	ProcessExpression step(Role source) {
		source.quit();
		return Bottom.getInstance();
	}

}
