package eu.ascens.helena.dev;

import java.util.List;

import eu.ascens.helena.dev.exceptions.ParameterListNotEqualException;
import eu.ascens.helena.dev.exceptions.ParameterListNotEqualException.ParamListType;
import eu.ascens.helena.dev.exceptions.ValueNotMatchingVariableTypeException;
import eu.ascens.helena.metadata.OperationType;

/**
 * This is the abstract class for an operation being called on a component.
 *
 * @author Annabelle Klarl
 */
public abstract class Operation implements AbstractHelenaInstance {

	protected final OperationType type;

	private final List<? extends Variable<? extends Object>> actualDataParams;

	public Operation(
			List<? extends Variable<? extends Object>> actualDataParams) {

		this.type = OperationType.getType(this.getClass());
		this.actualDataParams = actualDataParams;

		if (this.actualDataParams.size() != this.type.getDataParams().size()) {
			throw new ParameterListNotEqualException(ParamListType.DATA_PARAMS,
					this.type.getDataParams().size(),
					this.actualDataParams.size());
		}
		for (int i = 0; i < this.actualDataParams.size(); i++) {
			if (!this.type.getDataParams().get(i).getType()
					.isInstance(actualDataParams.get(i))) {
				throw new ValueNotMatchingVariableTypeException(
						this.type.getDataParams().get(i).getType(),
						actualDataParams.get(i).getClass());
			}
		}
	}

	public OperationType getType() {
		return this.type;
	}

	List<? extends Variable<? extends Object>> getActualDataParams() {
		return this.actualDataParams;
	}
}
