package eu.ascens.helena.dev;

import java.util.Set;

import eu.ascens.helena.dev.exceptions.NoBooleanValueException;
import eu.ascens.helena.dev.exceptions.PropertyNotDeclaredInClassException;
import eu.ascens.helena.dev.exceptions.ReflectionException;

/**
 * This class represents a negation of a guard.
 *
 * @author Annabelle Klarl
 */
public class NotGuard extends Guard {

	private final Guard guard;

	public NotGuard(Guard guard) {
		this.guard = guard;
	}

	@Override
	Set<Component> lockObjects(Role source) {
		return this.guard.lockObjects(source);
	}

	/**
	 * This method evaluates whether the negation of a guard is true.
	 *
	 * @param source the role for which the guard should be evaluated
	 * @return
	 * @throws PropertyNotDeclaredInClassException This exception is thrown if
	 *             the guard evaluates a property which is not defined in its
	 *             base class.
	 * @throws ReflectionException This exception is thrown if the guard
	 *             evaluates a property which could not be retrieved via
	 *             reflection.
	 * @throws NoBooleanValueException This exception is thrown if the guard did
	 *             not return a boolean value.
	 */
	@Override
	boolean isTrue(Role source) throws PropertyNotDeclaredInClassException,
			ReflectionException, NoBooleanValueException {
		return !this.guard.isTrue(source);
	}
}
