package eu.ascens.helena.dev;

import java.util.Set;

import eu.ascens.helena.dev.exceptions.NoBooleanValueException;
import eu.ascens.helena.dev.exceptions.PropertyNotDeclaredInClassException;
import eu.ascens.helena.dev.exceptions.ReflectionException;

/**
 * This class represents an abstract guard in Helena.
 *
 * @author Annabelle Klarl
 */
public abstract class Guard {

	/**
	 * This method returns all components which must be locked to evaluate the
	 * guard for the given role.
	 *
	 * @param source the role for which the guard should be evaluated
	 * @return
	 */
	abstract Set<Component> lockObjects(Role source);

	/**
	 * This method evaluates whether the guard is true for the given role.
	 *
	 * @param source the role for which the guard should be evaluated
	 * @return
	 * @throws PropertyNotDeclaredInClassException This exception is thrown if
	 *             the guard evaluates a property which is not defined in its
	 *             base class.
	 * @throws ReflectionException This exception is thrown if the guard
	 *             evaluates a property which could not be retrieved via
	 *             reflection.
	 * @throws NoBooleanValueException This exception is thrown if the guard did
	 *             not return a boolean value.
	 */
	abstract boolean isTrue(Role source)
			throws PropertyNotDeclaredInClassException, ReflectionException,
			NoBooleanValueException;
}
