package eu.ascens.helena.dev;

import eu.ascens.helena.dev.exceptions.BottomException;

/**
 * This class represents the empty process expression (after giving up the
 * role).
 *
 * @author Annabelle Klarl
 */
class Bottom extends ProcessExpression {

	private static Bottom singleton;

	private Bottom() {
	}

	public static Bottom getInstance() {
		if (singleton == null) {
			singleton = new Bottom();
		}
		return singleton;
	}

	/**
	 * This method should never be called.
	 *
	 * @param source the role executing the process expression bottom
	 * @throws BottomException This exception is thrown if bottom should be
	 *             evaluated.
	 */
	@Override
	ProcessExpression step(Role source) throws BottomException {
		throw new BottomException(source);
	}

}
