package eu.ascens.helena.dev;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * This class holds some auxiliaries.
 *
 * @author Annabelle Klarl
 */
public class Auxiliaries {

	/**
	 * Helper method for getting items as set.
	 *
	 * @param items
	 * @return
	 */
	public static <T> Set<T> getAsSet(
			@SuppressWarnings("unchecked") T... items) {
		Set<T> set = new HashSet<>();
		for (T item : items) {
			set.add(item);
		}
		return set;
	}

	/**
	 * Helper method for getting items as list.
	 *
	 * @param items
	 * @return
	 */
	public static <T> List<T> getAsList(
			@SuppressWarnings("unchecked") T... items) {
		List<T> list = new ArrayList<>(items.length);
		for (T item : items) {
			list.add(item);
		}
		return list;
	}

	/**
	 * Helper method to unify two sets into one set
	 *
	 * @param first
	 * @param second
	 * @return
	 */
	public static <T> Set<T> unify(Set<T> first, Set<T> second) {
		HashSet<T> union = new HashSet<>();
		union.addAll(first);
		union.addAll(second);
		return union;
	}

	/**
	 * Helper method to build a process term from a list of actions and a
	 * process term. This method will recursively built action prefixes from the
	 * actions given in the list and finally the given process term.
	 *
	 * @param p the process term to be executed after the sequence of actions
	 * @param actions a list of actions in sequential ordering
	 * @return
	 */
	public static ProcessExpression buildActionPrefix(ProcessExpression p,
			Action... actions) {
		ProcessExpression pt = p;
		for (int i = actions.length - 1; i >= 0; i--) {
			pt = new ActionPrefix(actions[i], pt);
		}
		return pt;
	}
}
