package eu.ascens.helena.dev;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

/**
 * This class models asynchronous message exchange.
 *
 * @author Annabelle Klarl
 */
class AsynchronousInputChannel extends RoleInputChannel {

	private final BlockingQueue<Message> queuedMsgs;

	public AsynchronousInputChannel(int capacity) {
		this.queuedMsgs = new ArrayBlockingQueue<>(capacity);
	}

	@Override
	protected synchronized int getFreeMessageSpots() {
		return this.queuedMsgs.remainingCapacity();
	}

	@Override
	protected synchronized void writeToChannel(Message msg) {
		this.queuedMsgs.offer(msg);
	}

	@Override
	protected synchronized Message peekAtChannel() {
		return this.queuedMsgs.peek();
	}

	@Override
	protected synchronized Message takeFromChannel()
			throws InterruptedException {
		Message msg = this.queuedMsgs.poll();
		return msg;
	}

	@Override
	protected void waitUntilMessageWasWritten(Message msg)
			throws InterruptedException {
		return;
	}
}
