package eu.ascens.helena.p2p;

import java.util.Set;

import eu.ascens.helena.dev.Component;
import eu.ascens.helena.dev.Ensemble;
import eu.ascens.helena.dev.exceptions.ComponentAlreadyAdoptsRoleException;
import eu.ascens.helena.dev.exceptions.ComponentNotInEnsembleException;
import eu.ascens.helena.dev.exceptions.PropertyNotDeclaredInClassException;
import eu.ascens.helena.dev.exceptions.ReflectionException;
import eu.ascens.helena.dev.exceptions.RoleTypeNotAllowedForComponentTypeException;
import eu.ascens.helena.dev.exceptions.RoleTypeNotAllowedForEnsembleException;
import eu.ascens.helena.dev.exceptions.TooManyRoleInstancesException;

public class TransferEnsemble extends Ensemble {

	public TransferEnsemble(String ensembleID, Set<Component> comps) {
		super(ensembleID, comps);
	}

	@Override
	public void startEnsemble(Component initialComponent)
	        throws RoleTypeNotAllowedForEnsembleException,
	        RoleTypeNotAllowedForComponentTypeException,
	        ComponentNotInEnsembleException, TooManyRoleInstancesException,
	        ReflectionException, PropertyNotDeclaredInClassException,
	        ComponentAlreadyAdoptsRoleException {
		this.createRole(Requester.class, initialComponent);
	}
}
