package eu.ascens.helena.p2p;

import eu.ascens.helena.dev.Auxiliaries;
import eu.ascens.helena.dev.Component;
import eu.ascens.helena.dev.CompAttrGetter;
import eu.ascens.helena.dev.Ensemble;
import eu.ascens.helena.dev.ProcessExpression;
import eu.ascens.helena.dev.Quit;
import eu.ascens.helena.dev.ReceiveMessageAction;
import eu.ascens.helena.dev.Role;
import eu.ascens.helena.dev.SendMessageAction;
import eu.ascens.helena.dev.Variable;
import eu.ascens.helena.dev.exceptions.PropertyNotDeclaredInClassException;
import eu.ascens.helena.dev.exceptions.ReflectionException;
import eu.ascens.helena.p2p.messages.ReqFileMessage;
import eu.ascens.helena.p2p.messages.SndFileMessage;

public class Provider extends Role {

	// global variables for behavior
	protected final Variable<Provider> self = new Variable<>(Provider.class);
	protected final Variable<Requester> req = new Variable<>(Requester.class);

	public Provider(Component comp, Ensemble ens, Integer capacity) {
		super(comp, ens, capacity);
		this.self.setValue(this);
	}

	@Override
	protected ProcessExpression initializeRoleBehavior()
			throws ReflectionException, PropertyNotDeclaredInClassException {
		return Auxiliaries.buildActionPrefix(Quit.getInstance(),
				new ReceiveMessageAction(new ReqFileMessage(this.req)),
				new SendMessageAction(this.req,
						new SndFileMessage(new Variable<>(
								new CompAttrGetter<>("content",
										Integer.class).getValue(this),
								Integer.class))));
	}
}